#!/usr/bin/env python3

"""
This script ensures that you have a debugger installed and then generates VS Code config files to use it.
"""

import os
import sys
import json
import shutil

dirs = ["0-demo", "1", "2", "3", "4", "5", "6"]
debugger = "lldb" if sys.platform == "darwin" else "gdb"

if shutil.which(debugger) is None:
    raise Exception(f"Debugger not found, please install it: {debugger}")

launch_config = dict(version="0.2.0", configurations=[])
for d in dirs:
    launch_config["configurations"].append({
        "name": f"Task {d}",
        "type": "cppdbg",
        "request": "launch",
        "program": f"${{workspaceFolder}}/{d}/main",
        "cwd": f"${{workspaceFolder}}/{d}",
        "args": [],
        "stopAtEntry": False,
        "MIMode": debugger,
        "environment": [],
        "externalConsole": False,
        "preLaunchTask": f"Build task {d}"
    })

tasks = dict(version="0.2.0", tasks=[])
for d in dirs:
    tasks["tasks"].append({
        "label": f"Build task {d}",
        "type": "shell",
        "command": "make",
        "options": {
            "cwd": f"${{workspaceFolder}}/{d}"
        },
    })


dirname = os.path.dirname(__file__)

os.makedirs(f"{dirname}/.vscode", exist_ok=True)
with open(f"{dirname}/.vscode/launch.json", "w") as fd:
    json.dump(launch_config, fp=fd, indent="    ")
with open(f"{dirname}/.vscode/tasks.json", "w") as fd:
    json.dump(tasks, fp=fd, indent="    ")
