CFLAGS := -std=c11 -g -O0 -Wall -Wextra
ASAN_FLAGS := -fsanitize=address -fno-omit-frame-pointer
VALGRIND_FLAGS := --leak-check=full --track-origins=yes
TARGET := main

.PHONY: all run asan valgrind clean

all: $(TARGET)

run: $(TARGET)
	./$(TARGET)

asan: $(TARGET)-asan
	./$(TARGET)-asan

valgrind: $(TARGET)
	valgrind $(VALGRIND_FLAGS) ./$(TARGET)

clean:
	rm -f $(TARGET)

$(TARGET): main.c Makefile
	$(CC) $(CFLAGS) $< -o $@

$(TARGET)-asan: main.c Makefile
	$(CC) $(CFLAGS) $(ASAN_FLAGS) $< -o $@
