// Permitted users registered in the ATM:
// 1) user_id = 20, pin = 4555, balance = 1234,
// 2) user_id = 30, pin = 9105, balance = 305

#include "atm.h"
#include <stdio.h>
#include <stdbool.h>

#define TEST_CASE(fn) do { \
    printf("Testing %.68s\x1B[70G", #fn); \
    if (fn()) { \
        puts("OK"); \
    } else { \
        puts("FAILED"); \
    } \
} while (0)

bool check_non_existing_user(void)
{
    bool ret;
    atm_psy_t *atm = atm_newatm();
    if (atm_authenticate(atm, 0, 5000) == UNKNOWN) {
        ret = true;
    } else {
        ret = false;
    }
    atm_dispose(atm);
    return ret;
}

int main(int argc, char *argv[])
{
    TEST_CASE(check_non_existing_user);
    return 0;
}
