#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdbool.h>
#include <string.h>

#define MAZE_SPACE  ((char)'.')
#define MAZE_CHERRY ((char)'*')
#define MAZE_OBSTCL ((char)'@')
#define MAZE_PLAYER ((char)'O')

#define ANSI_CLEAR  ((const char*)"\x1B[2J")
#define ANSI_0_0    ((const char*)"\x1b[0;0H")

#define AT(mazedim,x,y) (mazedim*y + x)

static void print_maze(char *maze, int mazedim)
{
    for (int i = 0; i < mazedim; ++i) {
        for (int j = 0; j < mazedim; ++j) {
            putchar(maze[AT(mazedim, j, i)]);
        }
        putchar('\n');
    }
    putchar('\n');
}

static void gameloop(char *maze, int mazedim, int startx, int starty)
{
    char op;
    bool running = true;
    int newstartx, newstarty;

    while (running) {
        bool move_player = true;
        printf("%s", ANSI_CLEAR);
        printf("%s", ANSI_0_0);
        print_maze(maze, mazedim);
        printf("Select next operation [w/a/s/d/anything else=quit]: ");
        scanf(" %c", &op);
        switch (op) {
        case 'w':
            newstartx = startx;
            newstarty = starty - 1;
            break;
        case 'a':
            newstartx = startx - 1;
            newstarty = starty;
            break;
        case 's':
            newstartx = startx;
            newstarty = starty + 1;
            break;
        case 'd':
            newstartx = startx + 1;
            newstarty = starty;
            break;
        default:
            running = false;
            break;
        }

        if (newstartx >= mazedim || newstartx < 0 || newstarty >= mazedim || newstarty < 0) {
            move_player = false;
        } else {
            if (maze[AT(mazedim, newstartx, newstarty)] == MAZE_OBSTCL) {
                move_player = false;
            } else {
                if (maze[AT(mazedim, newstartx, newstarty)] == MAZE_CHERRY) {
                    printf("Cherry picked!\n");
                }
            }
        }
        if (move_player) {
            maze[AT(mazedim, newstartx, newstarty)] = MAZE_PLAYER;
            maze[AT(mazedim, startx, starty)] = MAZE_SPACE;
            startx = newstartx;
            starty = newstarty;
        }
    }
}

static bool check_starting_pos(char *maze, int mazedim, int startx, int starty)
{
    if (startx >= mazedim || starty >= mazedim || startx < 0 || starty < 0) {
        return false;
    }
    char tocheck = maze[AT(mazedim, startx, starty)];
    if (tocheck == MAZE_CHERRY || tocheck == MAZE_OBSTCL) {
        return false;
    }
    return true;
}

static bool check_loaded_line(char *line, int mazedim)
{
    for (int i = 0; i < mazedim; ++i) {
        if (line[i] != MAZE_SPACE  &&
            line[i] != MAZE_CHERRY &&
            line[i] != MAZE_OBSTCL) {
            return false;
        }
    }
    return true;
}

int main(int argc, char *argv[])
{
    int ret = 0;
    int mazedim, startx, starty;
    char *maze;

    puts("08 Testing LCOV Maze");
    printf("Fill in the maze dimension: ");
    scanf("%d", &mazedim);
    putchar('\n');
    getchar(); // stupid newline
    if (mazedim < 0 || mazedim > 30) {
        fprintf(stderr, "Size out of range\n");
        return 1;
    }
    maze = malloc(mazedim * mazedim * sizeof(char));
    if (!maze) {
        perror("maze malloc");
        return 1;
    }
    char *ptr = maze;
    char line[mazedim + 2];
    for (int i = 0; i < mazedim; ++i) {
        if (fgets(line, mazedim + 2, stdin) == NULL) {
            perror("fgets");
            ret = 1;
        }
        if (feof(stdin)) {
            perror("EOF stdin");
            ret = 1;
        }
        if (check_loaded_line(line, mazedim)) {
            memcpy(ptr, line, mazedim);
            ptr += mazedim;
        } else {
            fprintf(stderr, "Incorrect format of the maze line: bad length or invalid characters.\n");
            ret = 1;
            break;
        }
    }
    if (ret == 0) {
        scanf("%d %d", &startx, &starty);
        if (check_starting_pos(maze, mazedim, startx, starty)) {
            maze[AT(mazedim, startx, starty)] = MAZE_PLAYER;
        } else {
            fprintf(stderr, "Bad player starting point, either out of bonds or on an obstacle or a cherry.\n");
            ret = 1;
        }
        if (ret == 0) {
            gameloop(maze, mazedim, startx, starty);        
        }
    }
    free(maze);
    return ret;
}
